;  "Standard Color Generator"
;  For Bally Arcade/Astrocade
;  By Andy Guevara
;  1982
;
;  This program generates 8 standard colors used in TV work.
;   
;  This assembly source code is from the "Machine Language Manager"
;  Manual, Page 7-4.
;
;  This program is for use with the 1982's "Machine Language Manager"
;  cartridge by The Bit Fiddlers.  The output of this program
;  must be loaded to a 300-baud "tape" and then loaded into the
;  "MLM" at memory address $4EAD: 
;
;  This program can be assembled using the ZMAC assembler.  Type:
;
;      zmac -i -m -o STDColor.bin -x STDColor.lst STDColor.asm
;
;  Version History:
;    .01 (July 16, 2013) - First Distributed version.  
;                        - Assemly re-typed and commented by Adam Trionfo
;                        - This source has been kept as true to the
;                          original as possible, which is why it doesn't
;                          use HVGLIB.H and instead uses equates for
;                          CALLs to the ROM routines.

;  Equates

SYSTEM  EQU     $FF            ;  System CALL
SYSSUK  EQU     $FF            ;  System CALL with SUCK option ON
INTPC   EQU     $00            ;  #  0  ; INTerPret with Context create
EXIT    EQU     $02            ;  #  2  ; eXit INTerpreter with Context
SETOUT  EQU     $16            ;  # 22  ; Set Display Ports
COLSET  EQU     $18            ;  # 24  ; COLors SET
RECTAN  EQU     $1C            ;  # 28  ; paint a RECTANgle
CLEAR   EQU     $2347          ;  "MLM" "Clear Screen" Routine

        ORG     $4EAD          ; Start of Program           	

        CALL    CLEAR          ;  "MLM" "Clear Screen" Routine
        DB      SYSSUK         ;  Start Interpreter with SUCK option ON
        DB      INTPC          ;  Begin Interpretering
        DB      SETOUT+1       ;  Set Display Ports  
        DB      $B6            ;  Blank Line = 182  (VERtical Blanking Line)
        DB      $13            ;  Right/Left Bounds (HORizontal Color Boundary)
        DB      $08            ;  Interrupt Line    (VERtical Blanking Line)
        ;
        DB      COLSET+1       ;  UPI COLors SET
        DW      L4EEB          ;  Color List
        DB      EXIT+1         ;  Stop Interpreter         
        LD      BC,$486E       ;  White Border
        LD      A,$55          ;  Color #1
        LD      DE,$0614
        DB      SYSTEM         ;  Start Interpreter  
        DB      RECTAN         ;  On-Board ROM Routine - Paint a Rectangle
        LD      HL,L4EDA       ;  Table Address
        LD      D,$09          ;  Y Postion of Bars           
        LD      B,$08          ;  # of Bars
L4ECB:  PUSH    BC             ;  Save it
        LD      A,(HL)         ;  Get Colors from Table
        INC     HL
        LD      E,(HL)         ;  Get X Position 
        INC     HL
        LD      BC,$420E       ;  Bar Size
        DB      SYSTEM         ;  Begin UPI Interpreting  
        DB      RECTAN         ;  On-Board ROM Routine - Paint a Rectangle
        POP     BC             ;  Get Back Count
        DJNZ    L4ECB          ;  Loop Back
        RET                    ;  All Done

        NOP                    ;  Filler Byte (So Data is Contiguous on Tape)

;  Table
L4EDA:  DB      $00,$17        ;  Color 00, at X=$17
        DB      $55,$24
        DB      $AA,$33
        DB      $FF,$3F
        DB      $00,$4C
        DB      $55,$57
        DB      $AA,$64
        DB      $FF,$71

        NOP                    ;  Filler Byte (So Data is Contiguous on Tape)

;  Color List
L4EEB:  DB      $AC            ; Green---+
        DB      $86            ; Yellow--+-- Left Colors
        DB      $07            ; White   |
        DB      $00            ; Black---+ 
;
        DB      $CD            ; Cyan----+
        DB      $5A            ; Red     +-- Right Colors
        DB      $2B            ; Magenta |
        DB      $F9            ; Blue----+

END                            ; End of Program
        